/**** lexer.c *********************************************************/
#include "global.h"

char	lexbuf[BSIZE];
int	lineno = 1;
int	tokenval = NONE;

int lexscan(void)	/* Scanner */
{
    int	t;
    while (1) {
	t = getchar();
	if (t == ' '||t == '\t')
	    ;	/* Entfernen von Leerraeumen */
	else if (t == '\n')
	    lineno++;
	else if (isdigit(t)) {	/* t ist eine Ziffer */
	    ungetc(t, stdin);
	    scanf("%d", &tokenval);
	    return NUM;
	}
	else if (isalpha(t)) {	/* t ist ein Buchstabe */
	    int p, b = 0;
	    while (isalnum(t)) {
		lexbuf[b++] = t;
		if (b >= BSIZE)
		    error("Compilierfehler");
		t = getchar();
	    }
	    lexbuf[b] = EOS;
	    if (t != EOF)
		ungetc(t, stdin);
	    p = lookup(lexbuf);
	    if (p == 0)
		p = insert(lexbuf, ID);
	    tokenval = p;
	    return symtable[p].token;
	}
	else if (t == EOF)
	    return DONE;
	else {
	    tokenval = NONE;
	    return t;
	}
    }
}
