/**** symbol.c ********************************************************/
#include "global.h"
#include <string.h>

#define STRMAX	999	/* Groesse des Lexem Arrays */
#define SYMMAX	100	/* Groesse der Symboltabelle */

char lexemes[STRMAX];
int  lastchar = -1;	/* zuletzt benutzte Lexemposition */
entry symtable[SYMMAX];
int  lastentry = 0;	/* zuletzt benutzter Symboltabelleneintrag */

int lookup(const char* s) /* uebergibt die Nummer des Eintrags fuer s */
{
    int p;
    for (p = lastentry; p >0; p--)
	if (strcmp(symtable[p].lexptr,s) == 0)
	    return p;
    return 0;
}

int insert(const char *s, int tok) /* uebergibt die Nummer des Eintrags
				      fuer s */
{
    int len;
    len = strlen(s);
    if (lastentry+1 >= SYMMAX)
	error("Symboltabelle voll");
    if (lastchar+len+1 >= STRMAX)
	error("Lexemarray voll");
    lastentry++;
    symtable[lastentry].token = tok;
    symtable[lastentry].lexptr = &lexemes[lastchar+1];
    lastchar += len + 1;
    strcpy(symtable[lastentry].lexptr, s);
    return lastentry;
}
