package main;

import gener.Parser;

import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

import tree.Node;
import vm.VM;

/**
 * Einfacher Rechner fuer Ausdruecke mit Gleitkommazahlen. Die Anwendung stellt
 * eine read-eval-print Schleife dar. Sie liest eine Eingabezeite (angefordert
 * bei Fragezeichen), fuehrt eine Syntaxanalyse durch, berechnet ihren Wert und
 * gibt das Ergebnis auf dem Bildschirm aus.
 * <p>
 * Die Anwendung kann durch Eingabe von 'q' beendet werden. Leerzeichen zwischen
 * Zahlen und Operatoren werden ignoriert.
 */
final class Calculator {
    private static final Scanner in = new Scanner(System.in);

    private Calculator() {} // Wir wollen keine Objekte

    public static void main(String[] args) {
        System.out.println("Taschenrechner\n");
        while (true) {
            String input = readLine();
            try {
                List<Object> program = compile(input);
                System.out.println("\nDer compilierte Code lautet: \n");
                for (Object code : program) System.out.println(code);
                System.out.println("\nDas Ergebnis lautet: " +
                        VM.compute(program));
            } catch (Exception e) {
                e.printStackTrace();
            } 
        }
    }

    private static String readLine() {
        System.out.print("\nEingabe (q = Ende)? ");
        String input = in.nextLine().trim();
        return input;
    }
    
    private static List<Object> compile(String input) throws Exception {
        List<Object> program = new LinkedList<>();
        Parser p = new Parser(new parser.Scanner(input+";;"));
        Node ast = (Node) p.parse().value;
        if (ast == null) System.exit(0);
        ast.compileTo(program);
        return program;        
    }
}
