package parser;
import java.util.HashMap;
import gener.Symbols;
import java_cup.runtime.Symbol;


/**
 * Simple scanner used for parsing numeric expressions.
 */
public final class Scanner implements java_cup.runtime.Scanner {
    /**
     * input line.
     */
    private String input;
    /**
     * current position.
     */
    private int pos = 0;
    /**
     * current character.
     */
    private char currentChar = ' ';
    
    /**
     * Mapping of characters to symbol constants.
     */
    private static final HashMap<Character, Integer> symbols = new HashMap<>();
    static {
        symbols.put('+', Symbols.ADD);
        symbols.put('-', Symbols.SUB);
        symbols.put('*', Symbols.MUL);
        symbols.put('/', Symbols.DIV);
        symbols.put('(', Symbols.LP);
        symbols.put(')', Symbols.RP);
        symbols.put('=', Symbols.ASSIGN);
        symbols.put(';', Symbols.EOF);
    }
    /**
     * Reads next character from input line a <tt>currentChar</tt>.
     */
    private void readNext() {
        currentChar = (pos == input.length()) ? ';' : input.charAt(pos++);
    }
    
    /**
     * Determins next symbol.
     * White space will be skipped. The symbol's identity is stored in
     * the variable <tt>currrentSymbol</tt> and the attribute value of
     * numbers is stored in <tt>currentValue</tt>. For non numeric tokens
     * <tt>currentValue</tt> is meaningless and undefined.
     * 
     * @throws IllegalArgumentException if unexpected characters are found.
     */
    public Symbol next_token() {
        while (Character.isWhitespace(currentChar))                //if (! input.equals("")) System.out.println("Syntaxfehler");
            readNext();
        if (Character.isDigit(currentChar)) {
            StringBuilder b = new StringBuilder();
            scanInt(b);
            if (currentChar == '.') {
                consumeChar(b);
                scanInt(b);        
            }
            if (currentChar == 'e' || currentChar == 'E') {
                consumeChar(b);
                if (currentChar == '+' || currentChar == '-')
                    consumeChar(b);
                scanInt(b);
            }
            return new Symbol(Symbols.NUM, b.toString());
        } else if (Character.isLetter(currentChar)) {
            StringBuilder b = new StringBuilder();
            while (Character.isLetterOrDigit(currentChar)) {
                consumeChar(b);
            }
            String id = b.toString();
            if (id.equals("q"))
                return new Symbol(Symbols.QUIT);
            else {
                return new Symbol(Symbols.ID, id);
            }
        } else {
            Integer sym = symbols.get(currentChar);
            if (sym == null)
                throw new IllegalArgumentException();
            readNext();
            return new Symbol(sym);
        }
    }

    /**
     * Reads an integer number
     * @param b receives the number
     */
    private void scanInt(StringBuilder b) {
        while (Character.isDigit(currentChar)) consumeChar(b);
    }
    /**
     * Appends the current character to the StringBuilder and moves on to the
     * next character.
     * @param b receives the current character
     */
    private void consumeChar(StringBuilder b) {
        b.append(currentChar);
        readNext();
    }
       
    /**
     * Creates a new scanner.
     * 
     * @param input input string.
     */
    public Scanner(String input) {
        this.input = input;
        readNext();
    }
}
