package tree;

import java.util.List;

import vm.OpCode;

/**
 * Realisiert die gemeinsamen Operation der binaeren Operationen.
 */
abstract class BinOpNode implements Node {
    protected final Node left;
    protected final Node right;
    
    protected BinOpNode(Node left, Node right) {
        this.left = left;
        this.right = right;
    }
   
    public void compileTo(List<Object> dest) {
        left.compileTo(dest);
        right.compileTo(dest);
        dest.add(this.opCode());
    }
    
    /**
     * Ermittelt den Operator fuer dieses Objekt.
     * @return Name des Operators
     */    
    protected abstract String operator();
    
    /**
     * Ermittelt Interpreter-Befehl.
     * @return Opcode der Operation
     */        
    protected abstract OpCode opCode();
    
    /**
     * Erzeugt die Darstellung fuer eine binaere Operation.
     * Der String lautet:
     * <pre>
     *     ( linke-Seite Operator rechte-Seite )
     * </pre>
     * Der Operator ist +,-,*,/ 
     * linke/rechte Seite sind die Stringdarstellung des jeweiligen Teilbaums.
     * @return Baum als String
     */
    public String toString() {
        return "(" + left.toString() + " " + operator() + " " + right.toString() + ")";
    }



}
