package tree;

import vm.OpCode;

public final class DivNode extends BinOpNode {
    public DivNode(Node left, Node right) {
        super(left, right);
    }
    
    protected OpCode opCode() {
        return OpCode.DIV;
    }

    public double value() {
        return left.value() / right.value();
    }
    
    protected String operator() {
        return "/";
    }  
}
