package tree;

import java.util.List;

import vm.OpCode;
import vm.Variables;

/**
 * Repraesentiert den Zugriff auf eine Variable.
 */
public final class IdNode implements Node {
    private String varName;

    public IdNode(String varName) {
        this.varName = varName;
    }

    public double value() {
        return Variables.load(varName);
    }
    
    @Override
    public String toString() {
        return varName;
    }

    @Override
    public void compileTo(List<Object> dest) {
        dest.add(OpCode.LOAD);
        dest.add(varName);
    }
}
