package tree;

import java.util.List;

import vm.OpCode;
import vm.Variables;

/**
 * Repraesentieriert eine Zuweisung.
 */
public final class LetNode implements Node {
    private final String varName;
    private final Node expression;

    public LetNode(String varName, Node expression) {
        this.varName = varName;
        this.expression = expression;
    }

    public double value() {
        double value = expression.value();
        Variables.store(varName, value);
        return value;
    }

    @Override
    public String toString() {
        return "let " + varName + " = " + expression;
    }

    @Override
    public void compileTo(List<Object> dest) {
        expression.compileTo(dest);
        dest.add(OpCode.STORE);
        dest.add(varName);
    }
}
