package tree;

import vm.OpCode;

public final class MinusNode extends BinOpNode {
    public MinusNode(Node left, Node right) {
        super(left, right);
    }

    protected OpCode opCode() {
        return OpCode.SUB;
    }    

    public double value() {
        return left.value() - right.value();
    }
    
    protected String operator() {
        return "-";
    }
    
}
