package tree;

import vm.OpCode;

public final class MultNode extends BinOpNode {
    public MultNode(Node left, Node right) {
        super(left, right);
    }

    protected OpCode opCode() {
        return OpCode.MUL;
    }
    public double value() {
        return left.value() * right.value();
    }

    protected String operator() {
        return "*";
    }
}
