package tree;

import java.util.List;

import vm.OpCode;

public final class NegateNode implements Node {
    private final Node expression;
    
    public NegateNode(Node expression) {
        this.expression = expression;
    }

    public void compileTo(List<Object> dest) {
        expression.compileTo(dest);
        dest.add(OpCode.NEG);
    }
    
    public double value() {
        return - expression.value();
    }
    
    @Override
    public String toString() {
        return "-" + expression.toString();
    }
}
