package tree;

import java.util.List;

import vm.OpCode;

public final class NumberNode implements Node {
    private final double number;

    public NumberNode(double number) {
        this.number = number;
    }

    public void compileTo(List<Object> dest) {
        dest.add(OpCode.NUM);
        dest.add(Double.valueOf(number));
    }
    @Override
    public String toString() {
        return String.valueOf(number);
    }
    
    public double value() {
        return number;
    }
}
