package tree;

import vm.OpCode;

public final class PlusNode extends BinOpNode {
    public PlusNode(Node left, Node right) {
        super(left, right);
    }

    protected OpCode opCode() {
        return OpCode.ADD;
    }    

    public double value() {
        return left.value() + right.value();
    }
    
    protected String operator() {
        return "+";
    }
}
