package vm;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class VM {
    public static double compute(List<Object> program) {
        Deque<Object> stk = new ArrayDeque<>();
        Iterator<Object> pc = program.iterator();
        while (pc.hasNext()) {
            OpCode code = (OpCode) pc.next();
            double operand1 = 0.0;
            double operand2 = 0.0;
            if (code.compareTo(OpCode.DIV) <= 0) {
                operand2 = (Double) stk.pop();
                operand1 = (Double) stk.pop();
            }
            switch (code) {
            case ADD: {
                stk.push(operand1 + operand2);
                break;
            }
            case SUB: {
                stk.push(operand1 - operand2);
                break;
            }
            case MUL: {
                stk.push(operand1 * operand2);
                break;
            }
            case DIV: {
                stk.push(operand1 / operand2);
                break;
            }
            case NEG: {
                double arg = (Double) stk.pop();
                stk.push(-arg);
                break;
            }
            case NUM: {
                Object arg = pc.next();
                stk.push(arg);
                break;
            }
            case LOAD: {
                String name = (String) pc.next();
                stk.push(Variables.load(name));
                break;
            }
            case STORE: {
                String name = (String) pc.next();
                Variables.store(name, (Double) stk.peek());
                break;
            }
            }

        }
        return (Double) stk.pop();
    }
}
