package io;

import java.io.IOException;
import java.io.RandomAccessFile;

/**
 * A wrapper for <tt>java.io.RandomAccessFile</tt>.
 * All IOExceptions are transformed into <tt>io.IOException</tt>, to make the
 * exceptions unchecked.
 * <p>
 * Only those methods are implemented that are needed by
 * <tt>tree.CodeGenerationVisitor</tt>.
 */
public class UncheckedRandomAccess {
    private final RandomAccessFile r;

    public UncheckedRandomAccess(RandomAccessFile file) {
        r = file;
    }

    public long getFilePointer()  {
        try {
            return r.getFilePointer();
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void seek(long pos) {
        try {
            r.seek(pos);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeShort(int v) {
        try {
            r.writeShort(v);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(int b) {
        try {
            r.write(b);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeBytes(String s) {
        try {
            r.writeBytes(s);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public final void writeInt(int v) {
        try {
            r.writeInt(v);
        } catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

}
