package tree;

import static org.objectweb.asm.Opcodes.*;

import vartab.*;

public interface Codes {
    static final Type
        VOID_TYPE = new VoidType(),
        INT_TYPE = new IntegerType(),
        STRING_TYPE = new StringType();

    static final int PLUS_OP = 1, MINUS_OP = 2, MULT_OP = 3, DIV_OP = 4,
        MOD_OP = 5, CHS_OP = 6, GT_OP = 7, GTEQ_OP = 8, EQEQ_OP = 9,
        LT_OP = 10, LTEQ_OP = 11, NEQ_OP = 12, SGT_OP = 13, SGTEQ_OP = 14,
        SEQEQ_OP = 15, SLT_OP = 16, SLTEQ_OP = 17, SNEQ_OP = 18, OR_OP = 19,
        AND_OP = 20, NOT_OP = 21, SADD_OP = 22, ICONV_OP = 23, NEW_OP = 24,
        LEN_OP = 25, ALOAD_OP = 26, ASTO_OP = 27, JZ_OP = 28, JNZ_OP = 29,
        JUMP_OP = 30, JSR_OP = 31, RTS_OP = 32, RTN_OP = 33, EXIT_OP = 34,
        ENTR_OP = 35, GLOAD_OP = 36, GSTO_OP = 37, LOAD_OP = 38, STO_OP = 39,
        INT_LIT = 40, STR_LIT = 41, PRI_OP = 42, PRS_OP = 43, PRL_OP = 44,
        RDI_OP = 45, RDS_OP = 46, FMT_OP = 47, FME_OP = 48;

    static final String[] mem = {
        "x",                               // just a placeholder
        "+", "-", "*", "/", "%",           // arithmetic
        "-",                               // change sign
        ">", ">=", "==", "<", "<=", "!=",  // int
        ">", ">=", "==", "<", "<=", "!=",  // String
        "||", "&&", "!",                   // boolean
        "+", "",                           // concatenate, toInt
        "new",                             // new array
        "#",                               // array length
        ":",                               // formatting
        ":" 
    };
    
    static final int[] javaCodes = {0,
        IADD, ISUB, IMUL, IDIV, IREM,
        INEG,
        IF_ICMPGT, IF_ICMPGE, IF_ICMPEQ, IF_ICMPLT, IF_ICMPLE, IF_ICMPNE,
        IFGT, IFGE, IFEQ, IFLT, IFLE, IFNE, 0, 0, IFEQ, 0, 0, NEW, ARRAYLENGTH        
    };
}
