package tree;

import java.io.PrintStream;

import vartab.FunctionEntry;
import vartab.Functions;
import vartab.BlockContext;
import vartab.Type;
import vartab.VariableEntry;

public final class Dump {
    public static void dump(PrintStream out, String message, BlockContext s) {
        out.println();
        out.println(message);
        dump(out, s);
        out.println();
    }

    public static void dump(PrintStream out, Functions f) {
        out.println();
        out.println("functions: ");
        for (FunctionEntry v : f) {
            out.print(v.getResultType() + " ");
            out.print(v.getName() + "(");
            Type[] args = v.getTypesOfParameters();
            if (args.length > 0) {
                out.print(args[0]);
                for (int i = 1; i < args.length; ++i) {
                    out.print(", " + args[i]);
                }
            }
            out.println(")");
            v.getBlock().accept(new PrintVisitor(out));
        }
        out.println();
    }

    private static void dump(PrintStream out, BlockContext s) {
        if (s != null) {
            for (VariableEntry v : s) {
                String globalTag = v.isGlobal() ? " G" : "";
                out.println(v.getName() + ": " + v.getType() + ", "
                        + v.getAddress() + globalTag);
            }
            dump(out, s.getOuterContext());
        }
    }
}