package tree;

import java.util.List;

import vartab.FunctionEntry;

public final class FunctionCall implements INode {
    static final long UNDEFINED = -1;
    final String name;
    final List<INode> arguments;
    // to be filled in by visitors:
    FunctionEntry function = null;
    boolean lastCall = false;
    long callAddress = UNDEFINED;

    public FunctionCall(String name, List<INode> args) {
        this.name = name;
        this.arguments = args;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
}