package tree;

public final class IfStmt implements INode {
    final INode condition;
    final INode thenPart;
    final INode elsePart;

    public IfStmt(INode expr, INode thenStmt, INode elseStmt) {
        this.condition = expr;
        this.thenPart = thenStmt;
        this.elsePart = elseStmt;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
}
