package tree;

import vartab.Type;

public final class IndexExpr extends VarNode {
    final INode index;
    final VarNode reference;

    public IndexExpr(INode ref, INode index) {
        this.reference = (VarNode) ref;
        this.index = index;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
    
    Type type(int level) {
        return reference.type(level + 1);
    }
}