package tree;

import static tree.Codes.VOID_TYPE;

import java.util.ListIterator;

import vartab.FunctionEntry;

public final class LastCallVisitor extends DoNothingVisitor {
    private FunctionEntry fkt;
    private boolean isVoid;
    private boolean lastCall;
    
    @Override
    protected void visitFunction(FunctionEntry f) {
        fkt = f;
        isVoid = (f.getResultType() == VOID_TYPE);
        lastCall = true;
        f.getBlock().accept(this);
    }
    
    @Override
    public void visit(StatementSequence s) {
        ListIterator<INode> iter = s.stmts.listIterator(s.stmts.size());
        while (lastCall)
            iter.previous().accept(this);
    }
    
    @Override
    public void visit(IfStmt s) {
        boolean lastInElse = lastCall;
        s.thenPart.accept(this);
        if (s.elsePart != null) {
            lastCall = lastInElse;
            s.elsePart.accept(this);
        }
        lastCall = false;
    }
    
    @Override
    public void visit(BinOp e) {
        if (e.operator == Codes.OR_OP || e.operator == Codes.AND_OP)
            e.right.accept(this);
    }
    
    @Override
    public void visit(CallStmt s) {
        s.functionCall.accept(this);
    }
    
    @Override
    public void visit(ReturnStmt s) {
        lastCall = true;
        if (!isVoid)
            s.expression.accept(this);
    }
    
    @Override
    public void visit(FunctionCall s) {
        if (lastCall && s.function.equals(fkt)) {
            s.lastCall = true;
            System.out.println(fkt.getName() + ": last call");
        }
        lastCall = false;
    }
    
    protected void otherStatement(INode s) {
        lastCall = false;
    }
}
