package tree;

import io.UncheckedRandomAccess;
import java.io.RandomAccessFile;

/**
 * Performs the function binding. It traverses the AST and inserts correct
 * function addresses into call oeprations.
 */
public final class LinkVisitor extends VisitorAdaptor {
    private final UncheckedRandomAccess out;

    /**
     * Create the Visitor.
     * @param file output file object.
     */
    public LinkVisitor(RandomAccessFile file) {
        out = new UncheckedRandomAccess(file);
    }

    @Override
    public void visit(FunctionCall f) {
        super.visit(f);
        if (f.callAddress != FunctionCall.UNDEFINED) {
            out.seek(f.callAddress);
            out.writeShort(f.function.getAddress());
        }
    }
}