package tree;

import java.util.List;
import vartab.Type;

public final class PrintStmt implements INode {
    final List<INode> expressions;
    final Type[] types;
    final INode format;
    final boolean printNewLine;

    public PrintStmt(INode format, List<INode> exprs, boolean newl) {
        this.format = format;
        this.expressions = exprs;
        this.printNewLine = newl;
        this.types = new Type[this.expressions.size()];
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
}