package tree;

import vartab.FunctionEntry;

/**
 * Determines maximum stack size.
 * Currently just a test class.
 */
public final class StackCountVisitor extends VisitorAdaptor {
    private int maxStackSize = 0;
    private int stackSize = 0;
    private boolean toStore = false;

    /**
     * Increments the stack size count.
     * The maximal value is stored in <code>maxStackSize</code>.
     * 
     * @param n increment.
     */
    private void incr(int n) {
        stackSize += n;
        if (stackSize > maxStackSize)
            maxStackSize = stackSize;
    }

    /**
     * Decrements the stack size count.
     * 
     * @param n decrement.
     */
    private void decr(int n) {
        stackSize -= n;
    }

    @Override
    public void visit(Program p) {
        maxStackSize = 0;
        stackSize = 0;
        p.stmts.accept(this);
        System.err.println("stack size of _MAIN_: " + maxStackSize);
        for (FunctionEntry f : p.listOfFunctions) {
            maxStackSize = 0;
            stackSize = 0;
            f.getBlock().accept(this);
            //f.setMaxStack(maxStackSize);
            System.err.println(
                "stack size of " + f.getName() + ": " + maxStackSize);
        }
    }

    @Override
    public void visit(IfStmt s) {
        s.condition.accept(this);
        stackSize = 0;
        s.thenPart.accept(this);
        if (s.elsePart != null)
            s.elsePart.accept(this);
    }

    @Override
    public void visit(WhileStmt s) {
        s.condition.accept(this);
        stackSize = 0;
        s.body.accept(this);
    }

    @Override
    public void visit(DoWhileStmt s) {
        s.condition.accept(this);
        stackSize = 0;
        s.body.accept(this);
    }

    @Override
    public void visit(ReturnStmt s) {
        if (s.expression != null)
            s.expression.accept(this);
        stackSize = 0;
    }

    @Override
    public void visit(AssignStmt s) {
        s.rightHandSide.accept(this);
        toStore = true;
        s.leftHandSide.accept(this);
        stackSize = 0;
    }

    @Override
    public void visit(IndexExpr n) {
        toStore = false;
        n.reference.accept(this);
        n.index.accept(this);
        if (toStore)
            decr(1);
        decr(1);
    }

    @Override
    public void visit(PrintStmt s) {
        if (s.format != null) {
            s.format.accept(this);
            decr(1);
        }
        for (INode n : s.expressions) {
            n.accept(this);
            decr(1);
        }
    }

    @Override
    public void visit(ReadNode s) {
        if (s.prompt != null) {
            s.prompt.accept(this);
            decr(1);
        }
        incr(1);
    }

    @Override
    public void visit(VarRef v) {
        if (!toStore)
            incr(1);
        toStore = false;
    }

    @Override
    public void visit(CallStmt f) {
        f.functionCall.accept(this);
        stackSize = 0;
    }

    public void visit(FunctionCall f) {
        super.visit(f);
        decr(f.function.getNumberOfParameters());
        if (!f.function.getResultType().equals(Codes.VOID_TYPE))
            incr(1);
    }

    @Override
    public void visit(BinOp op) {
        if (op.operator == Codes.OR_OP || op.operator == Codes.AND_OP) {
            op.left.accept(this);
            decr(1);
            op.right.accept(this);
        } else {
            op.left.accept(this);
            op.right.accept(this);
            decr(1);
        }
    }

    @Override
    public void visit(IntLiteral lit) {
        incr(1);
    }

    @Override
    public void visit(StringLiteral lit) {
        incr(1);
    }
}
