package tree;

import java.util.List;

public final class StatementSequence implements INode {
    final List<INode> stmts;

    public StatementSequence(List<INode> stmts) {
        this.stmts = stmts;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
    
    public INode lastStatement(int delta) {
        int n = stmts.size() - delta;
        return n == 0 ? null : stmts.get(n - 1);
    }
}