package tree;

import vartab.Type;

public class VarExpr implements INode {
    final VarNode reference;
    final boolean isArray;

    public VarExpr(INode reference) {
        this.reference = (VarNode) reference;
        this.isArray = reference instanceof IndexExpr;
    }
    
    public void accept(IVisitor v) {
        v.visit(this);
    }

    public Type refType() {
        return reference.type(0);
    }
    
    public boolean isArray() {
        return isArray;
    }
}
