package vartab;

public final class ArrayType extends Type {
    private final Type element;

    public ArrayType(Type t) {
        element = t;
    }

    @Override
    public Type getElement() {
        return element;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public boolean equals(Object obj) {
        return (obj instanceof ArrayType
                && element.equals(((ArrayType)obj).element));
    }

    @Override
    public String toString() {
        return element.toString() + "[]";
    }

    @Override
    public String javaSignature() {
        return "[" + element.javaSignature();
    }
}
