package vartab;

import java.util.Iterator;
import java.util.HashMap;

public final class BlockContext implements Iterable<VariableEntry> {
    private final Frame frame;
    private final BlockContext outerContext;
    private final HashMap<String, VariableEntry> dict =
        new HashMap<String, VariableEntry>();

    public BlockContext(Frame frame, BlockContext outerContext) {
        this.frame = frame;
        this.outerContext = outerContext;
    }

    public void put(VariableEntry v) {
        VariableEntry previous = dict.put(v.getName(), v);
        if (previous != null)
            Errors.error("duplicate Declaration of " + v.getName());
        v.setAddress(frame);
    }

    public VariableEntry get(String name) {
        VariableEntry v = dict.get(name);
        if (v != null)
            return v;
        if (outerContext != null)
            return outerContext.get(name);
        return null;
    }

    public Iterator<VariableEntry> iterator() {
        return dict.values().iterator();
    }

    public BlockContext getOuterContext() {
        return outerContext;
    }
}
