package vartab;

/**
 * Die Klasse <code>Frame</code> verwaltet einen Speicherbereich.
 * Speicherbereiche sind der globale Speicher und die lokalen
 * Stackframes einer Funktion.
 * Mittels <code>addressCount</code> verwaltet die Klasse die Variablen-
 * adressen. Parameter beginnen mit 0, gefolgt von lokalen Adressen.
 */
public final class Frame {
    private int nextAddress = 0;
    private BlockContext currentBlock;

    /**
     * Legt einen neuen globalen Speicherbereich an.
     * */
    public static Frame createGlobal() {
        return new Frame(null);
    }
    
    /**
     * Legt einen neuen lokalen Speicherbereich an.
     */
    public static Frame createLocal(BlockContext outerContext) {
        return new Frame(outerContext);
    }
    
    private Frame(BlockContext outerContext) {
        currentBlock = new BlockContext(this, outerContext);
    }

    public int useNextAddress() {
        return nextAddress++;
    }

    public int numberOfVariables() {
        return nextAddress;
    }

    public boolean isGlobal() {
        return currentBlock.getOuterContext() == null;
    }

    public void newContext() {
        currentBlock = new BlockContext(this, currentBlock);
    }

    public BlockContext topScope() {
        return currentBlock;
    }

    public void leaveScope() {
        currentBlock = currentBlock.getOuterContext();
    }
}
