package vartab;

import java.util.HashMap;
import java.util.Iterator;

public final class Functions implements Iterable<FunctionEntry> {
    private final HashMap<String, FunctionEntry> dict = 
        new HashMap<String, FunctionEntry>();

    public void put(FunctionEntry v) {
        FunctionEntry previous = dict.put(v.getName(), v);
        if (previous != null)
            Errors.errorln("duplicate Declaration of " + v.getName());
    }

    public FunctionEntry get(String name) {
        return dict.get(name);
    }

    public Iterator<FunctionEntry> iterator() {
        return dict.values().iterator();
    }
}
