package vartab;

public final class VariableEntry {
    private final String name;
    private Type type;
    private int address;
    private Frame frame;

    public VariableEntry(String name, Type type) {
        this.name = name;
        this.type = type;
        this.address = 0;
    }

    public String getName() {
        return name;
    }

    public void setAddress(Frame frame) {
        this.frame = frame;
        this.address = frame.useNextAddress();
    }

    public int getAddress() {
        return address;
    }

    public Type getType() {
        return type;
    }
    
    public void setType(Type t) {
        type = t;
    }

    public boolean isGlobal() {
        return frame.isGlobal();
    }
}
