package parser;

import java_cup.runtime.Scanner;
import java_cup.runtime.Symbol;
import static gener.Symbols.*;

/**
 * This Scanner contains a test program written in tinyc. It can be used for
 * testing the parser.
 */
public final class DummyScanner implements Scanner {
    private int index = 0;
    private final Symbol[] syms = new Symbol[] {

        // int a = 20;
        s(INT), s(IDENTIFIER, "a"), s(EQ), s(INTEGER_LITERAL, 20), s(SEMICOLON),

        // int b;
        s(INT), s(IDENTIFIER, "b"), s(SEMICOLON),

        // if (a < 0)
        s(IF), s(LPAREN), s(IDENTIFIER, "a"), s(LT), s(INTEGER_LITERAL, 0),
        s(RPAREN),

        // b = -a;
        s(IDENTIFIER, "b"), s(EQ), s(MINUS), s(IDENTIFIER, "a"), s(SEMICOLON),

        // else
        s(ELSE),

        // b = 3;
        s(IDENTIFIER, "b"), s(EQ), s(INTEGER_LITERAL, 3), s(SEMICOLON),

        // println b;
        s(PRINTLN), s(IDENTIFIER, "b"), s(SEMICOLON) };

    public Symbol next_token() throws Exception {
        return index < syms.length ? syms[index++] : s(EOF);
    }

    private static Symbol s(int symNum) {
        return new Symbol(symNum);
    }

    private static Symbol s(int symNum, Object attribute) {
        return new Symbol(symNum, attribute);
    }
}
