/*------------------------------ header -------------------------------------*/
package gener;

import java_cup.runtime.Symbol;
import static gener.Symbols.*;

%%/*----------------------------- declarations ------------------------------*/

/* Class Declaration */
%public
%final
%class Scanner

/* Source handling */
%line
%column
%unicode

/* Interface to java-cup */
%cupsym Symbols
%cup
/*
 * %implements java_cup.runtime.Scanner
 * %function next_token
 * %type Symbol
 * %eofval{
 *   return new Symbol(EOF);
 * %eofval}
 * %eofclose
 */
 
%{
  private StringBuilder string = new StringBuilder();

  public int lineNumber() {
    return yyline;
  }
%}

/*------------------------------- regular definitions -----------------------*/

/* main character classes */
LineTerminator = \r|\n|\r\n
InputCharacter = [^\r\n]
WhiteSpace = {LineTerminator} | [ \t\f]
StringCharacter = [^\r\n\"\\]

/* comments */
Comment = {TraditionalComment} | {EndOfLineComment} 
TraditionalComment = "/*" {CommentContent} \*+ "/"
EndOfLineComment = "//" {InputCharacter}* {LineTerminator}
CommentContent = ( [^*] | \*+[^*/] )*

/* Numbers and Identifiers */
Identifier = [:jletter:][:jletterdigit:]*
DecIntegerLiteral = [0-9]+

/* Strings require an extra state */
%state STRINGS

%%/*---------------------------- regular expressions ------------------------*/

<YYINITIAL> {
  "else"                         { return new Symbol(ELSE); }
  "int"                          { return new Symbol(INT); }
  "string"                       { return new Symbol(STRING); }
  "if"                           { return new Symbol(IF); }
  "return"                       { return new Symbol(RETURN); }
  "void"                         { return new Symbol(VOID); }
  "while"                        { return new Symbol(WHILE); }
  "print"                        { return new Symbol(PRINT); }
  "println"                      { return new Symbol(PRINTLN); }
  "read"                         { return new Symbol(READ); }
  {Identifier}                   { return new Symbol(IDENTIFIER, yytext()); }  
  "{"                            { return new Symbol(LBRACE); }
  "}"                            { return new Symbol(RBRACE); }
  "("                            { return new Symbol(LPAREN); }
  ")"                            { return new Symbol(RPAREN); }
  ";"                            { return new Symbol(SEMICOLON); }
  ","                            { return new Symbol(COMMA); }
  "="                            { return new Symbol(EQ); }
  ">"                            { return new Symbol(GT); }
  "<"                            { return new Symbol(LT); }
  "=="                           { return new Symbol(EQEQ); }
  "!="                           { return new Symbol(NEQ); }
  ">="                           { return new Symbol(GTEQ); }
  "<="                           { return new Symbol(LTEQ); }
  "+"                            { return new Symbol(PLUS); }
  "!"                            { return new Symbol(NOT); }
  "-"                            { return new Symbol(MINUS); }
  "*"                            { return new Symbol(MULT); }
  "/"                            { return new Symbol(DIV); }
  \"                             { yybegin(STRINGS); string.setLength(0); }
  {DecIntegerLiteral}            { return new Symbol(INTEGER_LITERAL,
                                        Integer.valueOf(yytext())); }
  {Comment}                      { /* ignore */ }
  {WhiteSpace}                   { /* ignore */ }
}

<STRINGS> {
  \"                             { yybegin(YYINITIAL);
  								   return new Symbol(STRING_LITERAL,
  								   		string.toString());
  								 }
  {StringCharacter}+             { string.append( yytext() ); }
  {LineTerminator}               { throw new RuntimeException(
  		                             "Unterminated string at end of line");
  		                         }
}

.|\n		                     { throw new RuntimeException(
		                             "Illegal character \""+yytext()+
		                             "\" at line "+yyline+
		                             ", column "+yycolumn);
		                         }
