package tree;

import vartab.Type;

public final class BinOp implements INode {
    final int operator;
    Type type;
    INode left;
    INode right;

    public BinOp(int op, INode left, INode right) {
        this.operator = op;
        this.left = left;
        this.right = right;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
}
