package tree;

import static org.objectweb.asm.Opcodes.*;

import vartab.*;

public final class Codes {
    private Codes() {}
    
    public  static final Type
        VOID_TYPE = new VoidType(),
        INT_TYPE = new IntegerType(),
        STRING_TYPE = new StringType();

    public static final int PLUS_OP = 1, MINUS_OP = 2, MULT_OP = 3, DIV_OP = 4,
        MOD_OP = 5, CHS_OP = 6, GT_OP = 7, GTEQ_OP = 8, EQEQ_OP = 9,
        LT_OP = 10, LTEQ_OP = 11, NEQ_OP = 12, NOT_OP = 13, SCONV_OP = 14;

    public static final String[] mem = {
        "x",                               // just a placeholder
        "+", "-", "*", "/", "%",           // arithmetic
        "-",                               // change sign
        ">", ">=", "==", "<", "<=", "!=",  // Comparison
        "!",                               // not
        "",                                // toString
        ":" 
    };
    
    public static final int[] javaCodes = {0,
        IADD, ISUB, IMUL, IDIV, IREM,
        INEG,
        IF_ICMPGT, IF_ICMPGE, IF_ICMPEQ, IF_ICMPLT, IF_ICMPLE, IF_ICMPNE,
        IFEQ      
    };
    
    public static boolean isMath(int code) {
        return code >= PLUS_OP && code <= CHS_OP;
    }
    
    public static boolean isCompare(int code) {
        return code >= GT_OP && code <= NEQ_OP;
    }
    
    public static boolean isBool(int code) {
        return code == NOT_OP;
    }
}
