package tree;

import vartab.FunctionEntry;

/**
 * This abstract class provides an implementation of the visitor interface. It
 * traverses the AST without performing any operation. It is intended to be
 * sublassed when only a small number of visitor methods has to perform some
 * specific task. The appropriate methods are then to be overriden.
 */
public abstract class DoNothingVisitor implements IVisitor {        
    protected void visitFunction(FunctionEntry f) {
    }
    
    protected void visitProgram(Program p) {
    }
       
    public void visit(Program p) {
        visitProgram(p);
        for (FunctionEntry f : p.listOfFunctions)
            visitFunction(f);
    }
    
    protected void otherStatement(INode s) {
    }

    public void visit(StatementSequence b) {
        otherStatement(b);
    }

    public void visit(IfStmt s) {
        otherStatement(s);
    }

    public void visit(WhileStmt s) {
        otherStatement(s);
    }

    public void visit(ReturnStmt s) {
        otherStatement(s);
    }

    public void visit(AssignStmt s) {
        otherStatement(s);
    }

    public void visit(PrintStmt s) {
        otherStatement(s);
    }

    public void visit(ReadNode s) {
        otherStatement(s);
    }

    public void visit(VarRef v) {
    }

    public void visit(VarExpr e) {
    }

    public void visit(CallStmt f) {
        otherStatement(f);
    }

    public void visit(FunctionCall f) {
    }

    public void visit(BinOp op) {
    }

    public void visit(UnOp op) {
    }

    public void visit(IntLiteral lit) {
    }

    public void visit(StringLiteral lit) {
    }
}