package tree;

/**
 * This interface declares the visit-operations for all AST-node-types. The
 * distinction between the methods relies on the explicit reference to the
 * specific type.
 */
public interface IVisitor {
    void visit(Program p);
    void visit(StatementSequence b);
    void visit(IfStmt s);
    void visit(WhileStmt s);
    void visit(ReturnStmt s);
    void visit(AssignStmt s);
    void visit(PrintStmt s);
    void visit(ReadNode s);
    void visit(VarRef v);
    void visit(VarExpr varExpr);
    void visit(CallStmt f);
    void visit(FunctionCall f);
    void visit(BinOp op);
    void visit(UnOp op);
    void visit(IntLiteral lit);
    void visit(StringLiteral lit);     
}