package tree;

import java.util.List;

import vartab.Functions;
import vartab.BlockContext;
import vartab.Frame;

public final class Program implements INode {
    StatementSequence stmts;
    final Functions listOfFunctions;
    final Frame globalFrame;

    public Program() {
        this.stmts = null;
        this.listOfFunctions = new Functions();
        this.globalFrame = Frame.createGlobal();
    }

    public BlockContext topScope() {
        return globalFrame.topScope();
    }

    public Frame getGlobalFrame() {
        return globalFrame;
    }

    public Functions getFunctions() {
        return listOfFunctions;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }

    public void setBlock(List<INode> v) {
        stmts = new StatementSequence(v);
    }
}