package tree;

import static tree.Codes.VOID_TYPE;

import java.util.Iterator;

import static vartab.Errors.errorln;
import vartab.FunctionEntry;

public final class ReturnCheckVisitor extends DoNothingVisitor {
    private boolean returnIsOk;
    private String functionName;
    
    @Override
    protected void visitFunction(FunctionEntry f) {
        returnIsOk = false;
        functionName = f.getName();
        f.getBlock().accept(this);
        if (!returnIsOk && f.getResultType() != VOID_TYPE)
            errorln(functionName + " needs return statement");
    }

    @Override
    public void visit(StatementSequence b) {
        Iterator<INode> iter = b.stmts.iterator();
        while (!returnIsOk && iter.hasNext())
            iter.next().accept(this);
        if (returnIsOk && iter.hasNext())
            errorln("unreachable code in " + functionName);
    }

    @Override
    public void visit(IfStmt s) {
        s.thenPart.accept(this);
        boolean thenReturned = returnIsOk;
        returnIsOk = false;
        if (s.elsePart != null && thenReturned) {
            s.elsePart.accept(this);
            returnIsOk = returnIsOk && thenReturned;
        }
    }

    @Override
    public void visit(ReturnStmt s) {
        returnIsOk = true;
    }

    @Override
    public void visit(WhileStmt s) {
        s.body.accept(this);
        returnIsOk = false;
    }
}
