package tree;

import vartab.BlockContext;
import vartab.Type;
import vartab.VariableEntry;

public final class VarRef extends VarNode{
    final VariableEntry descriptor;
    final String name;

    public VarRef(BlockContext s, String name) {
        this.name = name;
        this.descriptor = s.get(name);
    }
    
    public String name() {
        return name;
    }
    
    Type type(int level) {
        if (descriptor == null) {
            return Codes.VOID_TYPE;
        }
        Type vtype = descriptor.getType();
        return vtype;
    }

    public void accept(IVisitor v) {
        v.visit(this);
    }
}