package vartab;

import tree.StatementSequence;

public final class FunctionEntry {
    private final String name;
    private final Type resultType;
    private final Type[] parameterTypes;
    private StatementSequence block;

    public FunctionEntry(String name, Type resultType, Type[] parameterTypes) {
        this.name = name;
        this.resultType = resultType;
        this.parameterTypes = parameterTypes;
    }

    public void setBlock(StatementSequence block) {
        this.block = block;
    }

    public StatementSequence getBlock() {
        return block;
    }

    public String getName() {
        return name;
    }

    public Type getResultType() {
        return resultType;
    }

    public int getNumberOfParameters() {
        return parameterTypes.length;
    }

    public Type[] getTypesOfParameters() {
        return parameterTypes;
    }

    public String getSignature() {
        StringBuilder b = new StringBuilder().append('(');
        for (Type t : parameterTypes) b.append(t.javaSignature());
        return b.append(')').append(resultType.javaSignature()).toString();
    }
}
