package java.closure;

import java.io.PrintStream;
import java.utils.Function1;

public class JavaPolynomials {
    private static PrintStream out = System.out;

    public static Function1<Double, Double> quadratic(final double a,
            final double b, final double c) {
        return new Function1<Double, Double>() {
            public Double apply(Double x) {
                return c + x * (b + a * x);
            }
        };
    }

    public static void main(String[] args) {
        Function1<Double, Double> square = quadratic(1, 0, 0);
        Function1<Double, Double> by2 = quadratic(0, 2, 0);
        Function1<Double, Double> plus1 = quadratic(0, 0, 1);

        out.println("square: " + square.apply(4.));
        out.println("by2:    " + by2.apply(4.));
        out.println("plus1:  " + plus1.apply(4.));

    }
}
