package java.higherOrder;

import java.util.Comparator;
import java.utils.Function1;
import java.utils.Function2;
import java.utils.List;
import java.utils.Lists;
import java.utils.Pair;

public class JavaListOperations {
    public static double max(List<Double> lst) {
        return lst.reduceLeft(new Function2<Double, Double, Double>() {
            public Double apply(Double x, Double y) {
                return x > y ? x : y;
            }
        });
    }

    public static double sum(List<Double> lst) {
        return lst.reduceLeft(new Function2<Double, Double, Double>() {
            public Double apply(Double x, Double y) {
                return x + y;
            }
        });
    }

    public static List<Double> sort(final List<Double> lst) {
        if (lst.isEmpty()) return lst;
        Pair<List<Double>, List<Double>> pair = lst.tail().partition(
            new Function1<Double, Boolean>() {
                public Boolean apply(Double x) {
                    return x <= lst.head();
                }
            });
        return sort(pair.x).append(Lists.cons(lst.head(), sort(pair.y)));
    }

    public static void main(String[] args) {
        List<Double> liste = Lists.create(1., 2., -3.4, 0.4, -2.1, 10.23);
        System.out.println("max: " + max(liste));
        System.out.println("sum: " + sum(liste));
        System.out.println("sorted: " + sort(liste));
        
        System.out.println("library: " + liste.sortWith(new Comparator<Double>() {
            public int compare(Double a, Double b) {
                return a == b ? 0 : a < b ? -1 : +1;
            }
        }));
    }
}
