package java.utils;

import java.util.Comparator;

public abstract class AbstractList<T> implements List<T> {
    public int size() {
        return this.isEmpty() ? 0 : this.tail().size() + 1;
    }
    
    public List<T> append(List<T> other) {
        return this.isEmpty() ? other : new Cons<T>(head(), tail().append(other));
    }
    
    public T reduceLeft(Function2<T,T, T> f) {
        return reduceLeft(f, head());
    }

    private T reduceLeft(Function2<T,T,T> f, T accu) {
        return this.isEmpty() ? accu :
            ((AbstractList<T>)tail()).reduceLeft(f, f.apply(accu, head()));
    }
    
    public Pair<List<T>,List<T>> partition(Function1<T,Boolean> p) {
        if (this.isEmpty())
            return Lists.pair(Lists.<T>nil(), Lists.<T>nil());
        Pair<List<T>,List<T>> rest = tail().partition(p);
        if (p.apply(head()))
            return Lists.pair(Lists.cons(head(), rest.x), rest.y);
        else
            return Lists.pair(rest.x, Lists.cons(head(), rest.y));
    }

    public List<T> sortWith(final Comparator<? super T> cmp) {
        if (this.isEmpty()) return this;
        Pair<List<T>, List<T>> pair = this.tail().partition(
            new Function1<T,Boolean>() {
                public Boolean apply(T x) {
                    return cmp.compare(x, AbstractList.this.head()) <= 0;
                }
            });
        return pair.x.sortWith(cmp).
                append(Lists.cons(this.head(), pair.y.sortWith(cmp)));
    }
    
    
    public String mkString(String first, String sep, String last) {
        StringBuilder b = new StringBuilder();
        b.append(first);
        List<T> p = this;
        while (! p.isEmpty()) {
            b.append(p.head());
            p = p.tail();
            if (! p.isEmpty())
                b.append(sep);
        }
        b.append(last);
        return b.toString();
    }
    
    public String toString() {
        return mkString("List(", ", ", ")");
    }

}
