package java.utils;

import java.util.Comparator;

public interface List<T> {
    public boolean isEmpty();
    public T head();
    public List<T> tail();
    
    public int size();
    public List<T> append(List<T> other);
    public T reduceLeft(Function2<T,T,T> f);
    public Pair<List<T>,List<T>> partition(Function1<T,Boolean> predicate);
    public List<T> sortWith(Comparator<? super T> cmp);
    public String mkString(String first, String sep, String last);
}
