package java.utils;

public class Lists {
    private static List<Object> NIL = new Nil<Object>();
    
    @SuppressWarnings("unchecked")
    public static <T> List<T> nil() {
        return (List<T>) NIL;
    }
    
    public static <T> List<T> cons(T head, List<T> tail) {
        return new Cons<T>(head, tail);
    }
    
    public static <U,V> Pair<U,V> pair(U a, V b) {
        return new Pair<U,V>(a, b);
    }
    
    public static <T> List<T> create(T ... lst) {
        List<T> result = Lists.<T>nil();
        for (int i = lst.length - 1; i >= 0; i--)
            result = Lists.cons(lst[i], result);
        return result;
    }
    

}
