package scala.closure

object ScalaPolynomials {
    def quadratic(a: Double, b: Double, c: Double) =
        (x: Double) => c + x * (b + a * x)
    
    def main(args: Array[String]) {
        val square = quadratic(1, 0, 0)
        val by2 = quadratic(0, 2, 0)
        val plus1 = quadratic(0, 0, 1)
        
        println("square: " + square(4))
        println("by2:    " + by2(4))
        println("plus1:  " + plus1(4))
    }

}