package scala.control

object While {
    def until(condition: =>Boolean)(block: =>Unit): Unit = {
        if (! condition) {
            block
            until(condition)(block)
        }
    }
    
    def untl(condition: => Boolean)(block: =>Unit): Unit =
        while (! condition) block
    
    def main(args: Array[String]) {
        var i = 1
        untl (i > 10) {
            printf("%2d * 7 = %2d%n", i, 7*i)
            i += 1
        }
    }
}