package scala.higherOrder

object ScalaListOperations {
    def max(lst: List[Double]) = lst reduceLeft(_ max _)
    
    def sum(lst: List[Double]) = lst.reduceLeft(_ + _)
    
    def sort(lst: List[Double]): List[Double] = lst match {
        case Nil => Nil
        case pivot::rest =>
            val (small, large) = rest.partition(_ <= pivot)
            sort(small):::pivot::sort(large)
    }
    
    def main(args: Array[String]) {
        val liste = List(1.2, -3.4, 0.4, -2.1, 10.23)
        println("max: " + max(liste))
        println("sum: " + sum(liste))
        println("sorted: " + sort(liste))
        
        println("library: " + liste.sortWith(_<_))
    }
    
}