package scala.utils

abstract class List[T] {
    def isEmpty(): Boolean
    def head(): T
    def tail(): List[T]
    
    def size(): Int =
        if (this.isEmpty())
            0
        else
            this.tail().size() + 1
            
    def append(other: List[T]): List[T] =
        if (this.isEmpty())
            other
        else
            new Cons[T](head(), tail().append(other))

    def reduceLeft(f: (T,T)=>T): T = {
        def reduce(rest: List[T], accu: T): T =
            if (this.isEmpty())
                accu
            else
                reduce(tail(), f(accu, head()))
        reduce(tail(), head())
    }
   
    def partition(predicate: (T)=>Boolean): (List[T],List[T]) = {
        if (this.isEmpty())
            (List[T](), List[T]())
        val rest = tail().partition(predicate)
        if (predicate(head()))
            (Cons(head(), rest._1), rest._2)
        else
            (rest._1, Cons(head(), rest._2));
    }
    
    def sortWith(cmp: (T,T)=>Boolean): List[T] = {
        if (this.isEmpty()) this
        else {
            val pair = tail().partition(x=>cmp(x,head()))
            pair._1.sortWith(cmp).append(Cons(this.head(), pair._2.sortWith(cmp)))
        }
    }
    
    def mkString(first: String, sep: String, last: String): String = {
        val b = new StringBuilder()
        b.append(first)
        var p = this
        while (! p.isEmpty()) {
            b.append(p.head())
            p = p.tail()
            if (! p.isEmpty())
                b.append(sep)
        }
        b.append(last)
        b.toString();

    }
    override def toString() = mkString("List(", ", ", ")")
}

object List {
    def apply[T](elements: T*) {
        var lst: List[T] = Nil.asInstanceOf[List[T]]
        var i = elements.length - 1
        while (i >= 0) {
            lst = Cons(elements(i), lst)
            i -= 1
        }
        lst
    }
}
object Nil extends List[Nothing] {
    override def isEmpty() = true
    override def head() = throw new NoSuchElementException
    override def tail() = throw new NoSuchElementException
}

case class Cons[T](head: T, tail: List[T]) extends List[T] {
    override def isEmpty() = false  
}
